function [rawhdr]=hdr2rawhdr(hdr)
%[rawhdr]=hdr2rawhdr(hdr)
%convert a hdr struct to a rawhdr struct.
%Input:
% hdr: a hdr struct variable
%Output:
% rawhdr: a rawhdr struct variable
%
%20040318, jdlee
%

db_name =[hdr.db_name  blanks(18)];
db_name	= [db_name(1:17) 0];

dim		= hdr.dim(:)'; if length(dim) < 4; dim = [dim 1]; end
vox		= hdr.vox(:)'; if length(vox) < 4; vox = [vox 0]; end
dim		= [4 dim(1:4) 0 0 0];	
pixdim		= [0 vox(1:4) 0 0 0];


glmax	   = 1;
glmin	   = 0;
bitpix 	   = 0;
descrip    = [hdr.descrip blanks(80)];
descrip    = [descrip(1:79) 0];
aux_file   = ['none' blanks(19) 0];
origin     = [hdr.origin(:)' 0 0]; 

%---------------------------------------------------------------------------
switch dt_str2num(hdr.datatype),
case 1,   bitpix = 1;  glmax = 1;        glmin = 0;
case 2,   bitpix = 8;  glmax = 255;      glmin = 0;
case 4,   bitpix = 16; glmax = 32767;    glmin = 0;
case 8,   bitpix = 32; glmax = (2^31-1); glmin = 0;
case 16,  bitpix = 32; glmax = 1;        glmin = 0;
case 64,  bitpix = 64; glmax = 1;        glmin = 0;
end
%---------------------------------------------------------------------------

%begin of rawhdr
rawhdr.byte_order = hdr.byte_order;
%struct header_key
rawhdr.hk.sizeof_hdr = 348;
rawhdr.hk.data_type  = ['dsr      ' 0];
rawhdr.hk.db_name       = db_name;
rawhdr.hk.extents       = 0;
rawhdr.hk.session_error = 0;
rawhdr.hk.regular       = 'r';
rawhdr.hk.hkey_un0      = '0';

%struct image_dimension
rawhdr.dime.dim        = dim;
rawhdr.dime.vox_units  = ['mm' 0 0];
rawhdr.dime.cal_units  = zeros(1,8);
rawhdr.dime.unused14   = 0;
rawhdr.dime.datatype   = dt_str2num(hdr.datatype);
rawhdr.dime.bitpix	   = bitpix;
rawhdr.dime.dim_un0	   = 0;
rawhdr.dime.pixdim	   = pixdim;
rawhdr.dime.vox_offset = hdr.offset;
rawhdr.dime.funused1   = hdr.scale;%SCALE in spm
rawhdr.dime.funused2   = 0;
rawhdr.dime.funused3   = 0;
rawhdr.dime.cal_max    = 0;
rawhdr.dime.cal_min	   = 0;
rawhdr.dime.compressed = 0;
rawhdr.dime.verified   = 0;
rawhdr.dime.glmax	   = glmax;
rawhdr.dime.glmin	   = glmin;

%struct data_history
rawhdr.hist.descrip	     = descrip;
rawhdr.hist.aux_file	 = aux_file;
rawhdr.hist.orient		 = 0;
rawhdr.hist.origin	 	 = origin; %spm-specific
rawhdr.hist.generated	 = zeros(1,10);
rawhdr.hist.scannum	     = zeros(1,10);
rawhdr.hist.patient_id	 = zeros(1,10);
rawhdr.hist.exp_date	 = zeros(1,10);
rawhdr.hist.exp_time	 = zeros(1,10);
rawhdr.hist.hist_un0	 = zeros(1,3);
rawhdr.hist.views		 = 0;
rawhdr.hist.vols_added	 = 0;
rawhdr.hist.start_field  = 0;
rawhdr.hist.field_skip	 = 0;
rawhdr.hist.omax		 = 0;
rawhdr.hist.omin		 = 0;
rawhdr.hist.smax		 = 0;
rawhdr.hist.smin		 = 0;

%end of rawhdr -------------------------------------


return